package jade;

import dataschema.Clock;
import organization.communicationOntology.CommunicationOntology;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.core.*;
import jade.behaviour.*;

public class PhysicalAgentImpl extends Agent {
	private Codec codec = new SLCodec();
	private Ontology ontology = CommunicationOntology.getInstance();
	private Object[] obj;
	private int count;
	
	protected void setup() {
		setEnabledO2ACommunication(true, 5);
		obj = getArguments();
		this.getContentManager().registerOntology(ontology);
		this.getContentManager().registerLanguage(codec);
		this.resetClock();
		addBehaviour(new timeMsgAckReceiving(this));
		addBehaviour(new timeMsgSending(this, obj));		
	}
	
	public void receiveAck() {
		count++;
		if (count==obj.length){
			addBehaviour(new timeMsgSending(this, obj));
			count=0;
		}
	}
	
	private void resetClock() {
		Clock.numberOfTimeslots = 10;
		Clock.period = 0;
		Clock.slot = 0;
	}

}



