package jade.behaviour;

import jade.core.behaviours.CyclicBehaviour;

import jade.content.*;
import jade.content.onto.basic.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import organization.communicationOntology.*;
import jade.PhysicalAgentImpl;

public class timeMsgAckReceiving extends CyclicBehaviour {
	  private ContentManager manager;
	  protected PhysicalAgentImpl myAgent;

	  public timeMsgAckReceiving(PhysicalAgentImpl a) {
		    super(a);
		    myAgent = a;
		    this.manager  = (ContentManager) a.getContentManager();
		  }

	  public void action() {
		    ACLMessage msg_CONFIRM = this.myAgent.receive(MessageTemplate.MatchPerformative(ACLMessage.CONFIRM));
            if (msg_CONFIRM != null) {
  			  
                try {
                    Action action = (Action) this.manager.extractContent(msg_CONFIRM);
                    if (action.getAction() instanceof Time)
                        myAgent.receiveAck(); 
                }
                catch(Exception e) {
                  e.printStackTrace();
                }
            }
            else
                block();
	  }

}
