package jade.behaviour;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.*;
import jade.core.AID;
import jade.PhysicalAgentImpl;

import organization.communicationOntology.CommunicationOntology;
import organization.communicationOntology.Time;
import dataschema.Clock;

public class timeMsgSending extends OneShotBehaviour {
	private Codec codec = new SLCodec();
	private Ontology ontology = CommunicationOntology.getInstance();
	private Object[] receivers;
	
	public timeMsgSending(PhysicalAgentImpl _a, Object[] _receivers) {
		super(_a);
		myAgent = _a;
		receivers = _receivers;
	}
		
    public void action() {
    	AID[] aid = new AID[receivers.length];
		Time time = new Time(Clock.getPeriod(),Clock.getSlot());
	    Action action = new Action();
	    action.setAction(time);
	    ACLMessage msg = new ACLMessage(ACLMessage.INFORM);

		for (int i=0; i<receivers.length;i++){
    		String receiver = (String) receivers[i];
    		aid[i]= new AID(receiver, AID.ISLOCALNAME);
    	    msg.addReceiver(aid[i]);
    	}
		
	    action.setActor(aid[0]);	    
	    msg.setLanguage(codec.getName());
	    msg.setOntology(ontology.getName());
	    try {
	         myAgent.getContentManager().fillContent(msg, action);
	         myAgent.send(msg);
	    } catch (Exception pe) {
	         System.out.println(pe.getMessage());
	    }
		Clock.updateTime();    
    }

}
