function [C_est D_est index per time] = RASF_NP(X,N,Pfa,sigma)
%--------- The algorithm for RASF_NP  --------

%------- input : 
%    X: hyperspectral data, 
%    N: the number of endmembers, 
%    sigma: white Gaussian noise variance (we assume it to be white 
%    Gaussian, if it is not a pre-whitening process should be done to make it white).

%------- output:  
%    (C_est D_est): the estimated affine set parameters, 
%    index: the index of estimated outlier pixel, 
%    per: the estimated percentage of outliers in the image, 
%    time: the computation time
%-----------------------------------------------------
% programmers: 
%    Hao-En Huang (email: b23004705@hotmail.com) 
%    Tsung-Han Chan (email: thchan@ieee.org)
% Date: 
%    May 5, 2012 
%-----------------------------------------------------   

 %--Given the upper bound and lower bound of number of outliers
  
             
 
 %-- Step 1: initialize the number of outlier estimate 

perest         = 5;                   %----perest is the estimated percent of outlier "Now"    
save_perest    = 0;                   %----compare whether it converge or not
upbound        = 10;                  %----the searching upperbound of outlier percent
lobound        = 0;                   %----the searching lowerbound of outlier percent 
 
[M L]          = size(X);
X_O            = X;

t0  = clock;      %----test for time



while ceil(perest*L/100)~=ceil(save_perest)


    
    
    %--- Step 2: obtain outlier and outlier-free data estimate and affine
    % set parameters estimate by using RASF algorithm
    

    
e     = zeros(M,L);
ee    = ones(M,L); 
tol   = 1 ;


 while tol >1.0e-005
    
    


X_n = X_O - e;    
d = mean(X_n,2);                     %--- d is the mean data cloud 
U = X_n-d*ones(1,L);
OPTS.disp = 0;
[C D] = eigs(U*U',N-1,'LM',OPTS);    %--- C is the set which we desired
alpha = C'*(X_n-repmat(d,[1,L]));    %--- alpha is the optimal solution



       
    e = X_O - ( C*alpha + repmat(d,[1,L]) );
    e_norm = sqrt(sum(e.^2));
    

   [eorror_norm error_index] = sort(e_norm,'descend');
   error_index = error_index(1:round(perest*L/100));               %--error_index is the perest% largest pixel index

%--- round is the function to 4 eliminate and 5 up to next digit


  tol=sum(sqrt(sum((ee-e).^2)))/(sum(sqrt(sum(ee.^2))));
  ee = e; 
  e(:,setdiff(1:L,error_index))=0;
  
 
   
 end
 
 

%------find the estimated C and d-------- 
X_n = X_O - e;
D_est = mean(X_n,2);                        %--- d is the mean data cloud 
U = X_n-D_est*ones(1,L);
OPTS.disp = 0;
[C_est D_XD] = eigs(U*U',N-1,'LM',OPTS);    %--- C is the set which we desired

%---------------------------------------- 
 
%---- find the projection of the data to the estimated-affine
alpha_est = C_est' *( X_O - e - repmat(D_est,[1 L]) );
X_EST     = C_est* alpha_est + repmat(D_est , [1 L]);



%--- Step 3 : Compute R_HAT ----%

X=X_O;
DIFF = X - X_EST - e;
COUNT_ERROR=0;
R_HAT=[];



for i=1:L
    
   R_HAT(:,i) =DIFF(:,i)'*DIFF(:,i)/(sigma^2);

end


[a_value a_index] = max(R_HAT);




%--- Step 4 : Update the upper bound, lower bound, and number of outlier estimate   



ITA = gammainc(a_value/2,M/2,'upper');
 
 if ITA<Pfa
         COUNT_ERROR = COUNT_ERROR+1; 
    end


save_perest = perest*L/100;
   
   
if COUNT_ERROR~=0
    lobound = round(perest*L/100)/(L/100);
    perest  = perest+(upbound-perest)/2;
else
    upbound = round(perest*L/100)/(L/100);
    perest  = perest-(perest-lobound)/2;
end


%---- step5 : use the while loop to test convergence

end




time =  etime(clock,t0);
per  = upbound;
index= error_index;








