% Jai Shri Ram 
% Original Program: 8th October 2010
% Revised and Comments added: 19th September 2012
%=====================================================================
% Programmer: 
% ArulMurugan Ambikapathi, E-mail: a.arulmurugan@gmail.com
% (We will be happy to read your comments and feedback)
% -------------------------------------------------------
% References:
% [1]. A. Ambikapathi, T.-H. Chan, W.-K.Ma, C.-Y. Chi, 
%      ``A robust minimum-volume enclosing simplex algorithm for hyperspectral unmixing,"
%      in {\it Proc. IEEE ICASSP}, Dallas, Texas, Mar. 14-19, 2010, pp. 1202-1205.
% 
% [2]. A. Ambikapathi, T.-H. Chan, W.-K. Ma, and C.-Y. Chi, ``Chance constrained robust minimum volume
%      enclosing simplex algorithm for hyperspectral unmixing," in IEEE Trans. Geoscience and Remote Sensing, vol. 49, no. 11,
%      pp. 4194-4209, Nov. 2011.
%======================================================================
% A implementation of RMVES (Robust Minimum-Volume Enclosing Simplex) Algorithm
% [A_est,sn_est, time, iter_cnt, FINAL_VOLUME] = RMVES_BATTERY(OBS,N,show_flag,alphaa)
%======================================================================
%  Input
%  OBS is M-by-L data matrix where M is the number of spectral bands (or number of observations)
%  and L is the total number of pixels (data length).   
%  N is the number of endmembers (or sources).
%  show_flag: 1 to display current information in RMVES, and 0, otherwise 
%  alphaa values can be set to 3 (for all SNRs), which corresponds to
%  eta=0.001 (please see Pg. 4202 of [2] for details about setting eta value)
%----------------------------------------------------------------------
%  Output
%  A_est is M-by-N: estimated endmember signatures (or mixing matrix) obtained by RMVES.
%  sn_e st is N-by-L: estimated abundance vectors (or source matrix) obtained by RMVES.
%  time is the computation time (in secs). 
%  iter_cnt is the passed number of iterations in RMVES. 
%  FINAL_VOLUME is the final value of abs(det(H));
%========================================================================

function [A_est,sn_est, time, iter_cnt, FINAL_VOLUME] = RMVES_BATTERY(OBS,N,show_flag,alphaa)
X=OBS;
save alphaa alphaa;
XXXXX_ori = X;
[www Rwww]=estNoise(X,'off'); % Please see  this reference: J. Nascimento and J. Bioucas-Dias, "Hyperspectral unmixing based on mixtures of Dirichlet components", IEEE Transactions on Geoscience and Remote Sensing, vol. 50, no. 3, pp. 863-878, 2012.
Cn=Rwww;
save Cn Cn;
t0 = clock;

%----------- Define default parameters------------------
TOL_obj = 1e-6; % convergence tolerance

%-------Step 1.  Dimension reduction through affine set fitting-----------------
[M,L] = size(X); Lq=L; 
d = mean(X,2);
U = X-d*ones(1,L);
R = U*U';
Rx_true = (R./L) - Cn;
[eV D] = eig(Rx_true);
C = eV(:,M-N+2:end);
save CCC C;
Xd = pinv(C)*(X-d*ones(1,L));  % Dimension reduced data vectors (Xd is (N-1)-by-L)
Xdq=Xd;

[M_new,L_new] = size(Xd);
if M_new <9
    Xi = convhulln(Xd'); % Used the quickhull algorithm to remove some redundant constraints which in no way will affect the results
    temp = vec(Xi);
    index = union(temp,temp(1));
    Lc = length(index);
    Xc = Xd(:,index);
else 
Xc=Xd;
Lc= L_new;
end
L=Lc;
Xd=Xc;
save Xd Xd;

%__________EXPANDED VCA INITIALIZATION____________________
[M0]= VCA(XXXXX_ori,'Endmembers',N); % Please see [2] for details of expanded VCA
MMM1 = pinv(C)*(M0-d*ones(1,N));% dimension reduced end member signature !! IT MUST BE N-1 by N
[zk1 yk1]= size(MMM1);
asu1 = MMM1(:,1:(yk1-1));
BB1 = asu1 - (MMM1(:,yk1)*ones(1,(yk1-1))); %this is N-1 by N-1
poda= inv(BB1);
VOL_VCA= abs(det(poda))
%_____________

% mean endmember
Mm = mean(M0,2);      % Mm is inside te simplex defined by the columns of M
Mm = repmat(Mm,1,N);
dM = M0 - Mm; % remove the MEAN
%  expand
  while (sum(sum(pinv(M0)*XXXXX_ori < 0)) ~= 0)
    % disp('yes getting inside the loop')
   M0 = M0 +5*dM;
 end
MMM = pinv(C)*(M0-d*ones(1,N));% dimension reduced end member signature !! IT MUST BE N-1 by N
[zk yk]= size(MMM);
asu = MMM(:,1:(yk-1));
BB = asu - (MMM(:,yk)*ones(1,(yk-1))); %this is N-1 by N-1
E= inv(BB);
g = inv(BB)* MMM(:,yk);
%_________________________________________________________________
obj0 = abs(det(E));
E0=[E g];
%%%%%%%%%%%%%%%%%%%NOW SOLVING TWO SOCP's%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% we use FMINCON: rowwise and element wise updation for  H and g resp%%%%%%%%
E1 = [ E g];
save E E;
    save g g;
  
 k = 0; rec = 1; iter_cnt = 0;lal= 0;
  while (rec > TOL_obj) & (iter_cnt<9*N)
     k = k+1;
     if k>N-1; k=1; end %so that 'k' loops between 1 and N-1 rows!
     save k k ;
      b=[];% Initialization
    
     for l = 1:N-1;
        Eij = [E(1:k-1,1:l-1),E(1:k-1,l+1:N-1);E(k+1:N-1,1:l-1),E(k+1:N-1,l+1:N-1)];
        b = [b;(-1)^(k+l)*det(Eij)];
    end
    
    % Normalization of the search direction
  b([b~=0]) = b([b~=0])./(max(abs(b([b~=0])))*ones(length(find(b~=0)),1));
    b0 = [b;0]; % we are using it
save b0 b0;
Hg_initial = E0(k,:)';% k th row and k th element

options = optimset('Display','on', 'Algorithm','active-set', 'GradObj','off');
 %%%%%%%%%FIRST SQP%%%%%%%%%%%%%%%%%%%%
BATTERY{1}=Cn;
BATTERY{2}=C;
BATTERY{3}=Xd;
BATTERY{4}=E;
BATTERY{5}=g;
BATTERY{6}=k;
BATTERY{7}=alphaa;
Hg1_opt= fmincon(@(Hg_initial) RMVESBATTERY_obj_fun(Hg_initial,b0),Hg_initial,[],[],[],[],[],[],@(Hg_initial) RMVESBATTERY_constraints(Hg_initial,BATTERY),options);
%x = fmincon(@(x) myfun(x,a1),[1;2],[],[],[],[],[],[],@(x) mycon(x,a2),options)
%%%%%%%%%SECOND SOCP%%%%%%%%%%%%%%%%%%%%
Hg2_opt= fmincon(@(Hg_initial) RMVESBATTERY_obj_fun2(Hg_initial,b0),Hg_initial,[],[],[],[],[],[],@(Hg_initial) RMVESBATTERY_constraints(Hg_initial,BATTERY),options);

%---------------------------------------------------------------------

yaa = [Hg1_opt];
ybb = [Hg2_opt];

    y = [yaa ybb];
    [val ind] = max([abs(b0'*Hg1_opt)  abs(b0'*Hg2_opt)]); % since the actual problem is the MAXimization problem
    y_true = y(:,ind);
    E(k,1:N-1) = y_true(1:N-1,1); %updated the corresponding 'k' th row
    g(k,1) = y_true(N); 

    E0 = [E g];
    save E E;
     save g g;
%     %------Step 6.---------------------
    if k == N-1
        iter_cnt = iter_cnt+1;
        rec = abs(obj0-abs(det(E)))/obj0;
        obj0 = abs(det(E));
        obj_record(iter_cnt)=obj0;
        if show_flag
            disp(' ');
            disp(strcat('Number of iterations: ', num2str(iter_cnt)))
            disp(strcat('Relative change in objective: ', num2str(rec)))
            disp(strcat('Current volume: ', num2str(obj0)))
        end
    end
  end
  FINAL_VOLUME = obj0;
%--------Step. 7 to Step. 9------------------
% g = H0(:,N);
H=E;
Hh=H;
Gg=g;

alpha(:,1) = inv(H)*g;
alpha(:,2:N) = inv(H)+alpha(:,1)*ones(1,N-1);
A_est = C*alpha+d*ones(1,N);
% The next 4 lines are used to ensure that the estimated endmember
% signatures are non-negative
ind_l0=min(A_est)<0;
A_est(:,ind_l0)=A_est(:,ind_l0)-(ones(M,1)*min(A_est(:,ind_l0)));
ind_g1=max(A_est)>1;
A_est(:,ind_g1)=A_est(:,ind_g1)./(ones(M,1)*(max(A_est(:,ind_g1))));

XX_reconst = C*Xdq+d*ones(1,Lq);
 A_esttt = [10^(-5)*A_est; ones(1,N)];
    X=[10^(-5)*XX_reconst;ones(1,Lq)];
    for i=1:size(X,2);
    sn_est(:,i)=lsqnonneg(A_esttt,X(:,i));
    end

%------------------------------------------
time = etime(clock,t0);




