%=====================================================================
% Programmers: 
% Wing-Kin Ma, E-mail: wkma@ieee.org
% Tsung-Han Chan, E-mail: chantsunghan@gmail.com
% Date: Sept. 10, 2009
% -------------------------------------------------------
% A practical implementation of the CAMNS-AVM method, as described in 
% ----------------------------------------------------
% W.-K. Ma, T.-H. Chan, C.-Y. Chi, and Y. Wang, Convex analysis for
% non-negative blind source separation with application in imaging, 
% a Chapter (37 pages) to appear in Convex Optimization in Signal 
% Processing and Communications (edited by D. P. Palomar and Y. C. Eldar), 
% Cambridge University Press, 2009.
%------------------------------------------------------
% function [Y_vol count] = CAMNS_AVM(X,N)
%======================================================================
% Output: 
% Y_vol is the L-by-N extracted soruce matrix, where L is the data length.
% count is the number of iterations
%---------------------------------------------------
% Inputs:
% X is the L-by-M observation matrix, where M is the number of
% observations.
% N is the number of sources. 
%========================================================================

function [Y_vol count]=CAMNS_AVM(X,N)

%----------- Define default parameters------------------
TOL_LP= 1e-3; % tolerance for (small) numerical errors in LP
TOL_EXT= 1e-3; % tolerance for extreme-point validation
TOL_ZEROS= 1e-6; % tolerance for eliminating zero observation points

%-----------(Modification 1) Remove All Zero vectors in Data Set X--------
% It is not meaningful to analyze the zero mixtures. 
[L,M]=size(X); % the given data set
index=find(sum(abs(X'))>=TOL_ZEROS);
Xn=X(index,:); 
LL=length(index);

%-----------Affine Set Fitting [Proposition 1]--------------
d= Xn*ones(M,1)/M;
[C,Sigma,V]= svds(Xn-d*ones(1,M),N-1,'L'); 
%-----------------CAMNS Refinement----------------
rp= randperm(M); % Randomly generate 1:M
Xn_initial= Xn(:,rp(1:N)); % Randomly select the N observations as the inilization of CAMNS_refinement
ALPHA= pinv(C)*(Xn_initial-d*ones(1,N)); % Dimension reduction
ARG= [ALPHA; ones(1,N)]; % Add one-vector as the argument matrix
pre= abs(det(ARG))*factorial(N-1);

i=0;
count=0;
rec=1;
pars.fid=0;
while (rec > 1e-13) & (i<10*N)
    i=i+1;
    desire=rem(i,N)+(rem(i,N)==0)*N;
    fixed=find((desire~=1:N)>0);
    for ii=1:N
        temp=ARG(:,fixed);
        bt(ii)=(-1)^(desire+ii)*det(temp(find(ii~=1:N),:));
    end
    bt([bt~=0])=bt([bt~=0])./(max(abs(bt([bt~=0])))*ones(1,length(find(bt~=0)))); 
    %--relax the absolutely objective function and add an extra constraint-------
    %%%%1%%%%
    b1=bt(1:N-1);
    A1=-[C.' b1'];
    c1=[d; bt(end)];
    Kt.l=LL+1;
    [x1 y1]=sedumi(A1,b1,c1,Kt,pars);
    %%%%2%%%%
    b2=-b1;
    A2=[-C.' b1'];
    c2=[d; -bt(end)];
    [x2 y2]=sedumi(A2,b2,c2,Kt,pars);
    %----compare---------------------
    y=[y1 y2];ARG1=ARG;ARG2=ARG;
    ARG1(1:N-1,desire)=y1; 
    ARG2(1:N-1,desire)=y2; 
    [val ind]=max(abs([det(ARG1) det(ARG2)]));
    y_true=y(:,ind);
    ARG(1:N-1,desire)=y_true;
    if desire==N
        count=count+1
        rec=abs(pre-abs(det(ARG))*factorial(N-1))/pre;
        pre=abs(det(ARG))*factorial(N-1);
    end
end
eALPHA=ARG(1:N-1,:);
S_vol=C*eALPHA+d*ones(1,N);
Y_vol=zeros(L,N);
Y_vol(index,:)=S_vol;

