%=====================================================================
% Programmers: 
% Fa-Yu Wang, E-mail: fayuwang@gmail.com, Phone: +886 937028747   
% Tsung-Han Chan, E-mail: chantsunghan@gmail.com
% Date: 04/27/2009
% -------------------------------------------------------
% Reference: 
% F.-Y. Wang, C.-Y. Chi, T.-H. Chan, and Y. Wang, Non-negative
% least-correlated component analysis for separation of dependent sources 
% by volume maximization,to appear in IEEE Trans. Pattern Analysis and 
% Machine Intelligence, 2009 (regular paper).
%==========================================================================
% COPY RIGHT: You are free to use these codes for non-commercial purpose.                                                               %                                     
%==========================================================================

clear all; close all; clc;

%=================initial setting=========================
N=2; % number of sources
M=2; % number of observations (sensors)

%=================Loading the source matrix================
load S;
S1=reshape(S(1,:),164,164);
S2=reshape(S(2,:),164,164);
L = size(S,2); 

%=================Show sources =====================
figure; 
subplot(121);imshow(S1);title('Source 1');
subplot(122);imshow(S2);title('Source 2');

%=================Forming the observation matrix==============

AA=rand(M,N);
A=(AA'./(ones(N,1)*sum(AA'))).'; % mixing matrix
X=A*S;       % sysetm mixing
 
%==================show observations==========================
X1=reshape(X(1,:),164,164);
X2=reshape(X(2,:),164,164);

figure;
subplot(121);imshow(X1);title('Observation 1');
subplot(122);imshow(X2);title('Observation 2');

%======================nLCA-IVM======================
[Y_IVM iter_cnt time]=nLCA_IVM(X, 0, 1);

% show a realization 
Y_IVM1=reshape(Y_IVM(1,:),164,164);
Y_IVM2=reshape(Y_IVM(2,:),164,164);

figure;
subplot(121);imshow(Y_IVM1);title('Extracted source 1 by nLCA-IVM');
subplot(122);imshow(Y_IVM2);title('Extracted source 2 by nLCA-IVM');

